"""
Test runner for Add Two Numbers problem

This script runs test cases and generates test_report.log
"""

import sys
import traceback

try:
    from solution import add
except ImportError:
    print("Error: Could not import solution.py")
    sys.exit(1)


def run_tests():
    """Run all test cases and generate test_report.log"""
    results = []
    passed = 0
    failed = 0

    # Test Case 1: Basic addition
    try:
        result = add(2, 3)
        if result == 5:
            results.append("[PASS] TC_001 - Basic addition (2 + 3 = 5)")
            passed += 1
        else:
            results.append(f"[FAIL] TC_001 - Expected 5 but got {result}")
            failed += 1
    except Exception as e:
        results.append(f"[FAIL] TC_001 - Exception: {str(e)}")
        failed += 1

    # Test Case 2: Negative numbers
    try:
        result = add(-1, 1)
        if result == 0:
            results.append("[PASS] TC_002 - Negative numbers (-1 + 1 = 0)")
            passed += 1
        else:
            results.append(f"[FAIL] TC_002 - Expected 0 but got {result}")
            failed += 1
    except Exception as e:
        results.append(f"[FAIL] TC_002 - Exception: {str(e)}")
        failed += 1

    # Test Case 3: Zero values
    try:
        result = add(0, 0)
        if result == 0:
            results.append("[PASS] TC_003 - Zero values (0 + 0 = 0)")
            passed += 1
        else:
            results.append(f"[FAIL] TC_003 - Expected 0 but got {result}")
            failed += 1
    except Exception as e:
        results.append(f"[FAIL] TC_003 - Exception: {str(e)}")
        failed += 1

    # Test Case 4: Large positive numbers
    try:
        result = add(500, 250)
        if result == 750:
            results.append("[PASS] TC_004 - Large numbers (500 + 250 = 750)")
            passed += 1
        else:
            results.append(f"[FAIL] TC_004 - Expected 750 but got {result}")
            failed += 1
    except Exception as e:
        results.append(f"[FAIL] TC_004 - Exception: {str(e)}")
        failed += 1

    # Test Case 5: Large negative numbers
    try:
        result = add(-100, -200)
        if result == -300:
            results.append("[PASS] TC_005 - Negative numbers (-100 + -200 = -300)")
            passed += 1
        else:
            results.append(f"[FAIL] TC_005 - Expected -300 but got {result}")
            failed += 1
    except Exception as e:
        results.append(f"[FAIL] TC_005 - Exception: {str(e)}")
        failed += 1

    # Write results to test_report.log
    with open('test_report.log', 'w') as f:
        f.write('\n'.join(results))

    # Print results to console
    print("\n" + "="*60)
    print("TEST RESULTS")
    print("="*60)
    for result in results:
        print(result)
    print("="*60)
    print(f"Total: {passed + failed} | Passed: {passed} | Failed: {failed}")
    print("="*60)
    print("\nResults written to: test_report.log")

    return passed, failed


if __name__ == "__main__":
    print("Running tests for Add Two Numbers problem...")
    passed, failed = run_tests()

    # Exit with error code if tests failed
    sys.exit(0 if failed == 0 else 1)
